#!/usr/bin/perl

#
# Ip2Nation Improved
#
# Queries whois servers for the netblocks associated with 'eu' in the 
# ip2nation database and updates the country code with the one reported.
#
# This code is licensed under the MIT licence which you can find at
# http://www.opensource.org/licenses/mit-license.php
#
#
# Copyright (C)2006 http://www.cosmix.org.
#
# CHANGELOG:
# v.1.0; 2006-03-06
# v.1.1; 2006-05-03; Public, added sleep() call.
#

use DBI();
use POSIX;

print('Connecting to db...');

# DB CONFIGURATION

$DBHOST='localhost';
$DBUSER='user';
$DBPASSWD='password';
$DBNAME='database';

$dbh = DBI->connect("DBI:mysql:database=$DBNAME;host=$DBHOST",$DBUSER, $DBPASSWD);

$sth = $dbh->prepare("SELECT ip FROM ip2nation WHERE country='eu'");

$sth->execute;
print("ok\n");
while (my $ref = $sth->fetchrow_hashref()) {
    $netnum = $ref->{'ip'};
	$IP[0] = floor($netnum / 16777216);
    $IP[1] = floor(($netnum - $IP[0]*16777216)/65536); 
    $IP[2] = floor(($netnum - $IP[0]*16777216 - $IP[1]*65536)/256);
    $IP[3] = floor($netnum - $IP[0]*16777216 - $IP[1]*65536 - $IP[2]*256);
	$ipAddress =  $IP[0] . "." . $IP[1] . "." . $IP[2] . "." . ($IP[3] +1);
	#	print "Processing netblock: $netnum ($ipAddress)\n";	
	$whoisout = `whois $ipAddress`;
	sleep(1);
	$countryCode = $1 if $whoisout =~ /country:[\t ]*(\w{2})/g;
	print "UPDATE ip2nation SET country='\L$countryCode' WHERE ip='$netnum'; \n";
}

$dbh->disconnect;
